/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.LinkLayerCompTest;

import com.quantumdata.LinkLayerCompTest.llctGui;
import com.quantumdata.std.InstrumentException;
import com.quantumdata.widgets.QDButton;
import com.quantumdata.widgets.QDCheckBox;
import com.quantumdata.widgets.QDLabel;
import com.quantumdata.widgets.QDPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JOptionPane;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SinkPage
extends QDPanel
implements ActionListener,
ChangeListener {
    private static final long serialVersionUID = 1L;
    private final String[] SinkTestNums = new String[]{"5.2.1.1 - Read one byte from valid DPCD address", "5.2.1.2 - Read twelve bytes from valid DPCD address", "5.2.1.3 - Write one byte to valid DPCD address", "5.2.1.4 - Write nine bytes to valid DPCD addresses", "5.2.1.5 - Write EDID offset (one byte I2C-over-Aux write)", "5.2.1.6 - Read one EDID byte (one byte I2C-over-Aux read)", "5.2.1.7 - EDID read (1 byte I2C-over-Aux segment write, 1 byte I2C-over-Aux offset write, 128 byte I2C-over-Aux read)", "5.2.1.8 - Illegal aux request syntax", "5.2.1.9 - Glitch Rejection", "5.2.1.10 - Interleaved EDID and DPCD Receiver Capability Read", "5.3.1.1 - Successful link training at all supported lane counts and link speeds", "5.3.1.2 - Successful link training with request of higher differential voltage swing during clock recovery sequence", "5.3.1.3 - Successful link training to a lower link rate due to clock recovery lock failure during clock recovery sequence", "5.3.1.4 - Successful link training with request of a change to pre-emphasize and/or voltage swing setting during channel equalization sequence", "5.3.1.5 - Successful link training at lower link rate due to loss of symbol lock during channel equalization sequence", "5.3.1.6 - Lane count reduction", "5.3.1.7 - Lane count increase", "5.3.2.1 - IRQ_HPD pulse due to loss of symbol lock and clock recovery lock", "5.3.2.2 - IRQ_HPD pulse due to loss of inter-lane alignment lock", "5.4.1.1 - Pixel data reconstruction", "5.4.1.2 - Main stream data unpacking and unstuffing - least packed TU", "5.4.1.3 - Main stream data unpacking and unstuffing - most packed TU", "5.4.2   - Main video stream format change handling", "5.4.3.1 - Entering and Exiting Power Save Mode", "5.4.3.2 - Resumption of Main Link Activity After Extended Idle"};
    private GridBagLayout m_sinkLayout;
    private QDCheckBox[] m_sinkTests;
    private QDButton m_selectAllBtn;
    private QDButton m_deselectAllBtn;
    private QDButton m_startTestsBtn;
    private QDButton m_endTestsBtn;
    private QDLabel m_testLbl;
    private QDLabel m_waitTimeLbl;
    private QDLabel m_sumLbl;
    private QDLabel[] m_testStatusLbl;
    private JSpinner m_waitTimeSpn;
    private JSpinner m_testItterSpn;
    private JSpinner[] m_itemItterSpn;
    private llctGui mainWin;
    private Thread myThread;

    public SinkPage(llctGui llctGui2) {
        this.mainWin = llctGui2;
        this.m_sinkTests = new QDCheckBox[this.SinkTestNums.length];
        this.m_itemItterSpn = new JSpinner[this.SinkTestNums.length];
        this.m_testStatusLbl = new QDLabel[this.SinkTestNums.length];
        this.m_sinkLayout = new GridBagLayout();
        this.setLayout(this.m_sinkLayout);
        Font font = new Font("SansSerif", 0, 10);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        QDPanel qDPanel = new QDPanel();
        qDPanel.setLayout(new BorderLayout());
        this.m_selectAllBtn = new QDButton("Select All");
        this.m_selectAllBtn.addActionListener(this);
        qDPanel.add((Component)this.m_selectAllBtn, "West");
        this.m_deselectAllBtn = new QDButton("Deselect All");
        this.m_deselectAllBtn.addActionListener(this);
        qDPanel.add((Component)this.m_deselectAllBtn, "East");
        this.m_sinkLayout.setConstraints(qDPanel, gridBagConstraints);
        this.add(qDPanel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.m_testLbl = new QDLabel("TESTS");
        this.m_sinkLayout.setConstraints(this.m_testLbl, gridBagConstraints);
        this.add(this.m_testLbl);
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 11;
        this.m_sumLbl = new QDLabel("TEST RESULTS");
        this.m_sumLbl.setVisible(false);
        this.m_sinkLayout.setConstraints(this.m_sumLbl, gridBagConstraints);
        this.add(this.m_sumLbl);
        QDPanel qDPanel2 = new QDPanel();
        qDPanel2.setLayout(new BorderLayout());
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 18;
        this.m_waitTimeLbl = new QDLabel(" Time Between Tests (sec)  ");
        this.m_sinkLayout.setConstraints(this.m_waitTimeLbl, gridBagConstraints);
        qDPanel2.add((Component)this.m_waitTimeLbl, "West");
        this.m_waitTimeSpn = new JSpinner();
        this.m_waitTimeSpn.setValue(new Integer(4));
        this.m_waitTimeSpn.addChangeListener(this);
        qDPanel2.add((Component)this.m_waitTimeSpn, "East");
        this.m_sinkLayout.setConstraints(qDPanel2, gridBagConstraints);
        this.add(qDPanel2);
        for (int i = 0; i < this.SinkTestNums.length; ++i) {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = i + 3;
            gridBagConstraints.gridwidth = 5;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.anchor = 18;
            this.m_sinkTests[i] = new QDCheckBox(this.SinkTestNums[i]);
            this.m_sinkTests[i].setFont(font);
            this.m_sinkTests[i].setSelected(true);
            this.m_sinkLayout.setConstraints(this.m_sinkTests[i], gridBagConstraints);
            this.m_sinkTests[i].addActionListener(this);
            this.add(this.m_sinkTests[i]);
            gridBagConstraints.gridx = 6;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            this.m_itemItterSpn[i] = new JSpinner();
            this.m_itemItterSpn[i].setValue(new Integer(1));
            this.m_itemItterSpn[i].addChangeListener(this);
            this.m_sinkLayout.setConstraints(this.m_itemItterSpn[i], gridBagConstraints);
            this.add(this.m_itemItterSpn[i]);
            gridBagConstraints.gridx = 7;
            gridBagConstraints.anchor = 11;
            this.m_testStatusLbl[i] = new QDLabel("IDLE");
            this.m_testStatusLbl[i].setForeground(Color.orange);
            this.m_testStatusLbl[i].setVisible(false);
            this.m_sinkLayout.setConstraints(this.m_testStatusLbl[i], gridBagConstraints);
            this.add(this.m_testStatusLbl[i]);
        }
        QDPanel qDPanel3 = new QDPanel();
        qDPanel3.setLayout(new BorderLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 30;
        gridBagConstraints.anchor = 17;
        this.m_startTestsBtn = new QDButton("Start Test");
        this.m_sinkLayout.setConstraints(this.m_startTestsBtn, gridBagConstraints);
        this.m_startTestsBtn.addActionListener(this);
        qDPanel3.add((Component)this.m_startTestsBtn, "West");
        QDLabel qDLabel = new QDLabel("  Number of Times  ");
        qDPanel3.add((Component)qDLabel, "Center");
        this.m_testItterSpn = new JSpinner();
        this.m_testItterSpn.setValue(new Integer(1));
        this.m_testItterSpn.addChangeListener(this);
        this.m_sinkLayout.setConstraints(this.m_testItterSpn, gridBagConstraints);
        qDPanel3.add((Component)this.m_testItterSpn, "East");
        this.m_sinkLayout.setConstraints(qDPanel3, gridBagConstraints);
        this.add(qDPanel3);
        this.m_endTestsBtn = new QDButton("End Tests");
        gridBagConstraints.gridx = 4;
        this.m_sinkLayout.setConstraints(this.m_endTestsBtn, gridBagConstraints);
        this.m_endTestsBtn.addActionListener(this);
        this.add((Component)this.m_endTestsBtn, gridBagConstraints);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        if (actionEvent.getSource() == this.m_selectAllBtn) {
            for (n = 0; n < this.SinkTestNums.length; ++n) {
                this.m_sinkTests[n].setSelected(true);
                this.m_itemItterSpn[n].setEnabled(true);
            }
        }
        if (actionEvent.getSource() == this.m_deselectAllBtn) {
            for (n = 0; n < this.SinkTestNums.length; ++n) {
                this.m_sinkTests[n].setSelected(false);
                this.m_itemItterSpn[n].setEnabled(false);
            }
        }
        for (n = 0; n < this.SinkTestNums.length; ++n) {
            this.HandleCheckBox(actionEvent, n);
        }
        if (actionEvent.getSource() == this.m_endTestsBtn) {
            try {
                this.mainWin.sendCmd("dptx:ellc");
            }
            catch (InstrumentException instrumentException) {
                this.mainWin.setErrorMsg("Failed Cancel Tests");
                try {
                    this.mainWin.sendCmd("dptx:rset");
                    this.mainWin.sendCmd("dptx:ellc");
                }
                catch (InstrumentException instrumentException2) {
                    this.mainWin.setErrorMsg("Fail Retry Cancel");
                }
            }
        }
        if (actionEvent.getSource() == this.m_startTestsBtn) {
            int n2;
            n = 0;
            this.m_sumLbl.setVisible(false);
            for (n2 = 0; n2 < this.SinkTestNums.length; ++n2) {
                this.m_testStatusLbl[n2].setVisible(false);
                this.m_testStatusLbl[n2].setText(" ");
            }
            for (n2 = 0; n2 < this.SinkTestNums.length; ++n2) {
                if (!this.m_sinkTests[n2].isSelected()) continue;
                try {
                    this.mainWin.sendCmd("dptx:star " + String.valueOf(n) + " " + String.valueOf(n2));
                    this.mainWin.sendCmd("dptx:snar " + String.valueOf(n) + " " + String.valueOf((Integer)this.m_itemItterSpn[n2].getValue()));
                }
                catch (InstrumentException instrumentException) {
                    this.mainWin.setErrorMsg("Failed setup Tests");
                    return;
                }
                ++n;
            }
            try {
                this.mainWin.sendCmd("dptx:star " + String.valueOf(n) + " 255");
                this.mainWin.sendCmd("dptx:snar " + String.valueOf(n) + " 0");
            }
            catch (InstrumentException instrumentException) {
                this.mainWin.setErrorMsg("Failed to close tests");
                return;
            }
            try {
                for (n2 = 1; n2 <= (Integer)this.m_testItterSpn.getValue(); ++n2) {
                    this.mainWin.sendCmd("dptx:llct " + String.valueOf(n2));
                    this.m_sumLbl.setVisible(true);
                    this.myThread = new Thread(new Runnable(){

                        public void run() {
                            for (int i = 0; i < SinkPage.this.SinkTestNums.length; ++i) {
                                if (!SinkPage.this.m_sinkTests[i].isSelected()) continue;
                                int n = 1;
                                boolean bl = true;
                                do {
                                    try {
                                        n = SinkPage.this.mainWin.getInt("dptx:lltr? " + String.valueOf(i));
                                        Thread.sleep(100L);
                                    }
                                    catch (Exception exception) {
                                        continue;
                                    }
                                    switch (n) {
                                        case 1: {
                                            SinkPage.this.m_testStatusLbl[i].setVisible(true);
                                            SinkPage.this.m_testStatusLbl[i].setText("In Progress");
                                            SinkPage.this.m_testStatusLbl[i].setForeground(Color.orange);
                                            break;
                                        }
                                        case 2: {
                                            Color color = new Color(69, 47, 9);
                                            SinkPage.this.m_testStatusLbl[i].setVisible(true);
                                            SinkPage.this.m_testStatusLbl[i].setText("Timeout");
                                            SinkPage.this.m_testStatusLbl[i].setForeground(color);
                                            bl = false;
                                            break;
                                        }
                                        case 3: {
                                            SinkPage.this.m_testStatusLbl[i].setVisible(true);
                                            SinkPage.this.m_testStatusLbl[i].setText("Cancel");
                                            SinkPage.this.m_testStatusLbl[i].setForeground(Color.blue);
                                            bl = false;
                                            return;
                                        }
                                        default: {
                                            SinkPage.this.m_testStatusLbl[i].setVisible(true);
                                            SinkPage.this.m_testStatusLbl[i].setText("Cancel");
                                            SinkPage.this.m_testStatusLbl[i].setForeground(Color.blue);
                                            bl = false;
                                            break;
                                        }
                                        case 4: {
                                            SinkPage.this.m_testStatusLbl[i].setVisible(true);
                                            SinkPage.this.m_testStatusLbl[i].setText("Fail");
                                            SinkPage.this.m_testStatusLbl[i].setForeground(Color.red);
                                            bl = false;
                                            break;
                                        }
                                        case 5: {
                                            SinkPage.this.m_testStatusLbl[i].setVisible(true);
                                            SinkPage.this.m_testStatusLbl[i].setText("Pass");
                                            SinkPage.this.m_testStatusLbl[i].setForeground(Color.green);
                                            bl = false;
                                            break;
                                        }
                                        case 6: {
                                            SinkPage.this.m_testStatusLbl[i].setVisible(true);
                                            SinkPage.this.m_testStatusLbl[i].setText("Skipped");
                                            SinkPage.this.m_testStatusLbl[i].setForeground(Color.blue);
                                            bl = false;
                                            break;
                                        }
                                        case 100: {
                                            SinkPage.this.m_testStatusLbl[i].setVisible(true);
                                            SinkPage.this.m_testStatusLbl[i].setText("Warning");
                                            SinkPage.this.m_testStatusLbl[i].setForeground(Color.yellow);
                                            bl = false;
                                            break;
                                        }
                                        case 101: {
                                            SinkPage.this.m_testStatusLbl[i].setVisible(true);
                                            SinkPage.this.m_testStatusLbl[i].setText("Not Judged");
                                            SinkPage.this.m_testStatusLbl[i].setForeground(Color.blue);
                                            bl = false;
                                            break;
                                        }
                                        case 102: {
                                            SinkPage.this.m_testStatusLbl[i].setVisible(true);
                                            SinkPage.this.m_testStatusLbl[i].setText("Waiting on User");
                                            SinkPage.this.m_testStatusLbl[i].setForeground(Color.orange);
                                            SinkPage.this.HandleUserInput();
                                            break;
                                        }
                                        case 127: {
                                            SinkPage.this.m_testStatusLbl[i].setVisible(true);
                                            SinkPage.this.m_testStatusLbl[i].setText("Waiting to start");
                                            SinkPage.this.m_testStatusLbl[i].setForeground(Color.orange);
                                        }
                                    }
                                } while (bl);
                            }
                        }
                    });
                    this.myThread.start();
                }
            }
            catch (InstrumentException instrumentException) {
                this.mainWin.setErrorMsg("Failed to start LLC Tests");
                return;
            }
        }
    }

    private void HandleCheckBox(ActionEvent actionEvent, int n) {
        if (actionEvent.getSource() == this.m_sinkTests[n]) {
            if (this.m_sinkTests[n].isSelected()) {
                this.m_itemItterSpn[n].setEnabled(true);
            } else {
                this.m_itemItterSpn[n].setEnabled(false);
            }
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.m_waitTimeSpn) {
            if ((Integer)this.m_waitTimeSpn.getValue() < 0) {
                this.m_waitTimeSpn.setValue(new Integer(0));
            }
            try {
                this.mainWin.sendCmd("dptx:satw " + String.valueOf((Integer)this.m_waitTimeSpn.getValue()));
            }
            catch (InstrumentException instrumentException) {
                return;
            }
        }
        if (changeEvent.getSource() == this.m_testItterSpn && (Integer)this.m_testItterSpn.getValue() < 1) {
            this.m_testItterSpn.setValue(new Integer(1));
        }
        for (int i = 0; i < this.SinkTestNums.length; ++i) {
            this.HandleItemSpn(changeEvent, i);
        }
    }

    private void HandleItemSpn(ChangeEvent changeEvent, int n) {
        if (changeEvent.getSource() == this.m_itemItterSpn[n] && (Integer)this.m_itemItterSpn[n].getValue() < 1) {
            this.m_itemItterSpn[n].setValue(new Integer(1));
        }
    }

    public void setWaitTimeSpn(int n) {
        this.m_waitTimeSpn.setValue(n);
    }

    public void UpdateStatus() {
        try {
            int n = this.mainWin.getInt("dptx:satw?");
            this.setWaitTimeSpn(n);
        }
        catch (InstrumentException instrumentException) {
            return;
        }
    }

    public void HandleUserInput() {
        String string = "Does The Video Look Good?";
        String string2 = "User Confirmation";
        int n = JOptionPane.showConfirmDialog(this, string, string2, 0, 3);
        try {
            String string3 = n == 0 ? "1" : "0";
            String string4 = "dptx:llui " + string3;
            this.mainWin.sendCmd(string4);
            Thread.sleep(100L);
        }
        catch (InstrumentException instrumentException) {
            this.mainWin.setErrorMsg("Failed to send user input");
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

